unit APComps;

interface

uses
  DsgnIntF,SysUtils,WinTypes,WinProcs,Messages,Classes,Graphics,
  Controls, Forms, Dialogs, Menus, StdCtrls, ExtCtrls, Buttons,
  CapBarEd, CapBar;

type
  TTest_Form = class(TForm)
    But_Active: TSpeedButton;
    MainMenu: TMainMenu;
    Mnu_Info: TMenuItem;
    But_Exit: TSpeedButton;
    Pnl_Grad: TPanel;
    Scroll_Steps: TScrollBar;
    Scroll_Waves: TScrollBar;
    CB_ShowButtons: TCheckBox;
    RG_Align: TRadioGroup;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    TitleBar: TTitleBar;
    CapBut01: TTitleButton;
    But_Gradient: TTitleButton;
    CapBut03: TTitleButton;
    CB_SwapGradient: TCheckBox;
    CB_ShowCaption: TCheckBox;
    Lbl_Steps: TLabel;
    Lbl_Waves: TLabel;
    ColorDialog: TColorDialog;
    Pnl_From: TPanel;
    Pnl_To: TPanel;
    FontDialog: TFontDialog;
    Pnl_Caption: TPanel;
    procedure But_ExitClick(Sender: TObject);
    procedure But_TestClick(Sender: TObject);
    procedure But_GradientClick(Sender: TObject);
    procedure But_ActiveClick(Sender: TObject);
    procedure swapClick(Sender: TObject);
    procedure Scroll_StepsChange(Sender: TObject);
    procedure TitleBarDisable(Sender: TObject);
    procedure TitleBarEnable(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Scroll_WavesChange(Sender: TObject);
    procedure CB_ShowButtonsClick(Sender: TObject);
    procedure RG_AlignClick(Sender: TObject);
    procedure CB_SwapGradientClick(Sender: TObject);
    procedure CB_ShowCaptionClick(Sender: TObject);
    procedure ColorClick(Sender: TObject);
    procedure Pnl_CaptionClick(Sender: TObject);
  private
  public
	end;

{ this is the definition for the registrationprocedure called by
	Delphi if you insert a component }
procedure Register;

var
  Test_Form: TTest_Form;

implementation
{$R *.DFM}

{ this procedure registers the component in the DCL of Delphi }
procedure Register;
begin
	RegisterComponents('Custom',[TTitleBar]);
	RegisterClass(TTitleButton);
  RegisterNoIcon([TTitleButton]);
  RegisterPropertyEditor(TypeInfo(TList),TTitleBar,'Buttons',
    TTitleBarButtons);
end;

procedure TTest_Form.But_ExitClick(Sender: TObject);
begin
	Close;
end;

procedure TTest_Form.But_TestClick(Sender: TObject);
begin
	ShowMessage('Here you can see how the TitleBarcomponent'+#13+#10+
  	'works. Try out the Buttons and look what happens...');
end;

procedure TTest_Form.But_GradientClick(Sender: TObject);
begin
	titlebar.fullgradient:=not titlebar.fullgradient;
  if titlebar.fullgradient then
{  	capbut02.caption:='Only Visible'}
  else
{  	capbut02.caption:='Full Size';}
end;

procedure TTest_Form.But_ActiveClick(Sender: TObject);
begin
	TitleBar.Enabled:=not TitleBar.Enabled;
  if But_Active.Down then
  	But_Active.Caption:='Deactivated'
  else
  	But_Active.Caption:='Activated';
end;

procedure TTest_Form.swapClick(Sender: TObject);
var
	c: tcolor;
begin
	c:=titlebar.coloractiveleft;
  titlebar.coloractiveleft:=titlebar.coloractiveright;
  titlebar.coloractiveright:=c;
  titlebar.enable;
end;

procedure TTest_Form.Scroll_StepsChange(Sender: TObject);
begin
	TitleBar.GradientSteps:=Scroll_Steps.Position;
  Scroll_Waves.Max:=Scroll_Steps.Position div 4;
  Lbl_Steps.Caption:=IntToStr(Scroll_Steps.Position);
end;

procedure TTest_Form.Scroll_WavesChange(Sender: TObject);
begin
	Titlebar.GradientWaves:=Scroll_Waves.Position;
  Lbl_Waves.Caption:=IntToStr(Scroll_Waves.Position);
end;

procedure TTest_Form.TitleBarDisable(Sender: TObject);
begin
	Pnl_Grad.Enabled:=not But_Active.Down;
end;

procedure TTest_Form.TitleBarEnable(Sender: TObject);
begin
	Pnl_Grad.Enabled:=True;
	Pnl_From.Color:=TitleBar.ColorActiveLeft;
  Pnl_To.Color:=TitleBar.ColorActiveRight;
  Scroll_Steps.Position:=TitleBar.GradientSteps;
  Scroll_Waves.Position:=TitleBar.GradientWaves;
  Scroll_Waves.Max:=TitleBar.GradientSteps div 4;
  CB_ShowButtons.Checked:=TitleBar.ShowButtons;
  CB_SwapGradient.Checked:=TitleBar.GradientSwap;
  CB_ShowCaption.Checked:=TitleBar.ShowCaption;
  RG_Align.ItemIndex:=Ord(TitleBar.CaptionAlignment);
  Pnl_Caption.Font.Assign(TitleBar.Font);
end;

procedure TTest_Form.FormShow(Sender: TObject);
begin
	titlebar.enable;
end;

procedure TTest_Form.CB_ShowButtonsClick(Sender: TObject);
begin
  TitleBar.ShowButtons:=CB_ShowButtons.Checked;
end;

procedure TTest_Form.CB_ShowCaptionClick(Sender: TObject);
begin
	TitleBar.ShowCaption:=CB_ShowCaption.Checked;
end;

procedure TTest_Form.RG_AlignClick(Sender: TObject);
begin
	titlebar.captionalignment:=TCapAlign(rg_align.itemindex);
end;

procedure TTest_Form.CB_SwapGradientClick(Sender: TObject);
begin
  TitleBar.GradientSwap:=CB_SwapGradient.Checked;
end;

procedure TTest_Form.ColorClick(Sender: TObject);
begin
	ColorDialog.Color:=TPanel(Sender).Color;
	if ColorDialog.Execute then
  begin
  	TPanel(Sender).Color:=ColorDialog.Color;
    if Sender=Pnl_From then
	    TitleBar.ColorActiveLeft:=ColorDialog.Color
    else
      TitleBar.ColorActiveRight:=ColorDialog.Color;
  end;
end;

procedure TTest_Form.Pnl_CaptionClick(Sender: TObject);
begin
	FontDialog.Font.Assign(TitleBar.Font);
	if FontDialog.Execute then
  begin
  	TitleBar.Font:=FontDialog.Font;
    Pnl_Caption.Font.Assign(FontDialog.Font);
  end;
end;

end.

